package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ResourceType, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeProtectedResourceResponse(
    resourceArn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    lastBackupTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse = {
    import DescribeProtectedResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        lastBackupTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastBackupTime)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly =
    zio.aws.backup.model.DescribeProtectedResourceResponse.wrap(buildAwsValue())
}
object DescribeProtectedResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeProtectedResourceResponse =
      zio.aws.backup.model.DescribeProtectedResourceResponse(
        resourceArn.map(value => value),
        resourceType.map(value => value),
        lastBackupTime.map(value => value)
      )
    def resourceArn: Optional[ARN]
    def resourceType: Optional[ResourceType]
    def lastBackupTime: Optional[Timestamp]
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getLastBackupTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastBackupTime", lastBackupTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse
  ) extends zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly {
    override val resourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val lastBackupTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastBackupTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse
  ): zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly =
    new Wrapper(impl)
}
