package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DescribeProtectedResourceRequest(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest = {
    import DescribeProtectedResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.DescribeProtectedResourceRequest.ReadOnly =
    zio.aws.backup.model.DescribeProtectedResourceRequest.wrap(buildAwsValue())
}
object DescribeProtectedResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeProtectedResourceRequest =
      zio.aws.backup.model.DescribeProtectedResourceRequest(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest
  ) extends zio.aws.backup.model.DescribeProtectedResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest
  ): zio.aws.backup.model.DescribeProtectedResourceRequest.ReadOnly =
    new Wrapper(impl)
}
