package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Conditions(
    stringEquals: Optional[Iterable[zio.aws.backup.model.ConditionParameter]] =
      Optional.Absent,
    stringNotEquals: Optional[
      Iterable[zio.aws.backup.model.ConditionParameter]
    ] = Optional.Absent,
    stringLike: Optional[Iterable[zio.aws.backup.model.ConditionParameter]] =
      Optional.Absent,
    stringNotLike: Optional[Iterable[zio.aws.backup.model.ConditionParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.Conditions = {
    import Conditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.Conditions
      .builder()
      .optionallyWith(
        stringEquals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stringEquals)
      .optionallyWith(
        stringNotEquals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stringNotEquals)
      .optionallyWith(
        stringLike.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stringLike)
      .optionallyWith(
        stringNotLike.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stringNotLike)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.Conditions.ReadOnly =
    zio.aws.backup.model.Conditions.wrap(buildAwsValue())
}
object Conditions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.Conditions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.Conditions =
      zio.aws.backup.model.Conditions(
        stringEquals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringNotEquals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringLike.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringNotLike.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stringEquals
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]]
    def stringNotEquals
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]]
    def stringLike
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]]
    def stringNotLike
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]]
    def getStringEquals: ZIO[Any, AwsError, List[
      zio.aws.backup.model.ConditionParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("stringEquals", stringEquals)
    def getStringNotEquals: ZIO[Any, AwsError, List[
      zio.aws.backup.model.ConditionParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("stringNotEquals", stringNotEquals)
    def getStringLike: ZIO[Any, AwsError, List[
      zio.aws.backup.model.ConditionParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("stringLike", stringLike)
    def getStringNotLike: ZIO[Any, AwsError, List[
      zio.aws.backup.model.ConditionParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("stringNotLike", stringNotLike)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.Conditions
  ) extends zio.aws.backup.model.Conditions.ReadOnly {
    override val stringEquals
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringEquals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ConditionParameter.wrap(item)
          }.toList
        )
    override val stringNotEquals
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringNotEquals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ConditionParameter.wrap(item)
          }.toList
        )
    override val stringLike
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringLike())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ConditionParameter.wrap(item)
          }.toList
        )
    override val stringNotLike
        : Optional[List[zio.aws.backup.model.ConditionParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringNotLike())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ConditionParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.Conditions
  ): zio.aws.backup.model.Conditions.ReadOnly = new Wrapper(impl)
}
