package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRestoreJobsResponse(
    restoreJobs: Optional[
      Iterable[zio.aws.backup.model.RestoreJobsListMember]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse = {
    import ListRestoreJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
      .builder()
      .optionallyWith(
        restoreJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.restoreJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly =
    zio.aws.backup.model.ListRestoreJobsResponse.wrap(buildAwsValue())
}
object ListRestoreJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRestoreJobsResponse =
      zio.aws.backup.model.ListRestoreJobsResponse(
        restoreJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def restoreJobs
        : Optional[List[zio.aws.backup.model.RestoreJobsListMember.ReadOnly]]
    def nextToken: Optional[String]
    def getRestoreJobs: ZIO[Any, AwsError, List[
      zio.aws.backup.model.RestoreJobsListMember.ReadOnly
    ]] = AwsError.unwrapOptionField("restoreJobs", restoreJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
  ) extends zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly {
    override val restoreJobs
        : Optional[List[zio.aws.backup.model.RestoreJobsListMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.RestoreJobsListMember.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
  ): zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly = new Wrapper(impl)
}
