package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsByLegalHoldResponse(
    recoveryPoints: Optional[
      Iterable[zio.aws.backup.model.RecoveryPointMember]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse = {
    import ListRecoveryPointsByLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse
      .builder()
      .optionallyWith(
        recoveryPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recoveryPoints)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly =
    zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse
      .wrap(buildAwsValue())
}
object ListRecoveryPointsByLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse =
      zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse(
        recoveryPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recoveryPoints
        : Optional[List[zio.aws.backup.model.RecoveryPointMember.ReadOnly]]
    def nextToken: Optional[String]
    def getRecoveryPoints: ZIO[Any, AwsError, List[
      zio.aws.backup.model.RecoveryPointMember.ReadOnly
    ]] = AwsError.unwrapOptionField("recoveryPoints", recoveryPoints)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse
  ) extends zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly {
    override val recoveryPoints
        : Optional[List[zio.aws.backup.model.RecoveryPointMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.RecoveryPointMember.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse
  ): zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly =
    new Wrapper(impl)
}
