package zio.aws.backup.model
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.MaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLegalHoldsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest = {
    import ListLegalHoldsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListLegalHoldsRequest.ReadOnly =
    zio.aws.backup.model.ListLegalHoldsRequest.wrap(buildAwsValue())
}
object ListLegalHoldsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListLegalHoldsRequest =
      zio.aws.backup.model.ListLegalHoldsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest
  ) extends zio.aws.backup.model.ListLegalHoldsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest
  ): zio.aws.backup.model.ListLegalHoldsRequest.ReadOnly = new Wrapper(impl)
}
