package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCopyJobsResponse(
    copyJobs: Optional[Iterable[zio.aws.backup.model.CopyJob]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListCopyJobsResponse = {
    import ListCopyJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListCopyJobsResponse
      .builder()
      .optionallyWith(
        copyJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.copyJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListCopyJobsResponse.ReadOnly =
    zio.aws.backup.model.ListCopyJobsResponse.wrap(buildAwsValue())
}
object ListCopyJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListCopyJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListCopyJobsResponse =
      zio.aws.backup.model.ListCopyJobsResponse(
        copyJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def copyJobs: Optional[List[zio.aws.backup.model.CopyJob.ReadOnly]]
    def nextToken: Optional[String]
    def getCopyJobs
        : ZIO[Any, AwsError, List[zio.aws.backup.model.CopyJob.ReadOnly]] =
      AwsError.unwrapOptionField("copyJobs", copyJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListCopyJobsResponse
  ) extends zio.aws.backup.model.ListCopyJobsResponse.ReadOnly {
    override val copyJobs
        : Optional[List[zio.aws.backup.model.CopyJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.CopyJob.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListCopyJobsResponse
  ): zio.aws.backup.model.ListCopyJobsResponse.ReadOnly = new Wrapper(impl)
}
