package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateLegalHoldResponse(
    title: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.backup.model.LegalHoldStatus] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    legalHoldId: Optional[String] = Optional.Absent,
    legalHoldArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    recoveryPointSelection: Optional[
      zio.aws.backup.model.RecoveryPointSelection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse = {
    import CreateLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse
      .builder()
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(legalHoldId.map(value => value: java.lang.String))(
        _.legalHoldId
      )
      .optionallyWith(
        legalHoldArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.legalHoldArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        recoveryPointSelection.map(value => value.buildAwsValue())
      )(_.recoveryPointSelection)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly =
    zio.aws.backup.model.CreateLegalHoldResponse.wrap(buildAwsValue())
}
object CreateLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateLegalHoldResponse =
      zio.aws.backup.model.CreateLegalHoldResponse(
        title.map(value => value),
        status.map(value => value),
        description.map(value => value),
        legalHoldId.map(value => value),
        legalHoldArn.map(value => value),
        creationDate.map(value => value),
        recoveryPointSelection.map(value => value.asEditable)
      )
    def title: Optional[String]
    def status: Optional[zio.aws.backup.model.LegalHoldStatus]
    def description: Optional[String]
    def legalHoldId: Optional[String]
    def legalHoldArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def recoveryPointSelection
        : Optional[zio.aws.backup.model.RecoveryPointSelection.ReadOnly]
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
    def getStatus: ZIO[Any, AwsError, zio.aws.backup.model.LegalHoldStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getLegalHoldId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("legalHoldId", legalHoldId)
    def getLegalHoldArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("legalHoldArn", legalHoldArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getRecoveryPointSelection: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointSelection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recoveryPointSelection",
      recoveryPointSelection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse
  ) extends zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly {
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
    override val status: Optional[zio.aws.backup.model.LegalHoldStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.backup.model.LegalHoldStatus.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val legalHoldId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.legalHoldId())
      .map(value => value: String)
    override val legalHoldArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.legalHoldArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val recoveryPointSelection
        : Optional[zio.aws.backup.model.RecoveryPointSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPointSelection())
        .map(value => zio.aws.backup.model.RecoveryPointSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse
  ): zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly = new Wrapper(impl)
}
