package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelLegalHoldRequest(
    legalHoldId: String,
    cancelDescription: String,
    retainRecordInDays: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest = {
    import CancelLegalHoldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest
      .builder()
      .legalHoldId(legalHoldId: java.lang.String)
      .cancelDescription(cancelDescription: java.lang.String)
      .optionallyWith(retainRecordInDays.map(value => value: java.lang.Long))(
        _.retainRecordInDays
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CancelLegalHoldRequest.ReadOnly =
    zio.aws.backup.model.CancelLegalHoldRequest.wrap(buildAwsValue())
}
object CancelLegalHoldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CancelLegalHoldRequest =
      zio.aws.backup.model.CancelLegalHoldRequest(
        legalHoldId,
        cancelDescription,
        retainRecordInDays.map(value => value)
      )
    def legalHoldId: String
    def cancelDescription: String
    def retainRecordInDays: Optional[Long]
    def getLegalHoldId: ZIO[Any, Nothing, String] = ZIO.succeed(legalHoldId)
    def getCancelDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(cancelDescription)
    def getRetainRecordInDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retainRecordInDays", retainRecordInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest
  ) extends zio.aws.backup.model.CancelLegalHoldRequest.ReadOnly {
    override val legalHoldId: String = impl.legalHoldId(): String
    override val cancelDescription: String = impl.cancelDescription(): String
    override val retainRecordInDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.retainRecordInDays())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest
  ): zio.aws.backup.model.CancelLegalHoldRequest.ReadOnly = new Wrapper(impl)
}
