package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  Timestamp,
  BackupVaultName,
  ResourceType,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RecoveryPointByBackupVault(
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    backupVaultName: Optional[BackupVaultName] = Optional.Absent,
    backupVaultArn: Optional[ARN] = Optional.Absent,
    sourceBackupVaultArn: Optional[ARN] = Optional.Absent,
    resourceArn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    createdBy: Optional[zio.aws.backup.model.RecoveryPointCreator] =
      Optional.Absent,
    iamRoleArn: Optional[IAMRoleArn] = Optional.Absent,
    status: Optional[zio.aws.backup.model.RecoveryPointStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    completionDate: Optional[Timestamp] = Optional.Absent,
    backupSizeInBytes: Optional[Long] = Optional.Absent,
    calculatedLifecycle: Optional[zio.aws.backup.model.CalculatedLifecycle] =
      Optional.Absent,
    lifecycle: Optional[zio.aws.backup.model.Lifecycle] = Optional.Absent,
    encryptionKeyArn: Optional[ARN] = Optional.Absent,
    isEncrypted: Optional[Boolean] = Optional.Absent,
    lastRestoreTime: Optional[Timestamp] = Optional.Absent,
    parentRecoveryPointArn: Optional[ARN] = Optional.Absent,
    compositeMemberIdentifier: Optional[String] = Optional.Absent,
    isParent: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault = {
    import RecoveryPointByBackupVault.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
      .builder()
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        sourceBackupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sourceBackupVaultArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(calculatedLifecycle.map(value => value.buildAwsValue()))(
        _.calculatedLifecycle
      )
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(
        encryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .optionallyWith(isEncrypted.map(value => value: java.lang.Boolean))(
        _.isEncrypted
      )
      .optionallyWith(
        lastRestoreTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastRestoreTime)
      .optionallyWith(
        parentRecoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.parentRecoveryPointArn)
      .optionallyWith(
        compositeMemberIdentifier.map(value => value: java.lang.String)
      )(_.compositeMemberIdentifier)
      .optionallyWith(isParent.map(value => value: java.lang.Boolean))(
        _.isParent
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly =
    zio.aws.backup.model.RecoveryPointByBackupVault.wrap(buildAwsValue())
}
object RecoveryPointByBackupVault {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointByBackupVault =
      zio.aws.backup.model.RecoveryPointByBackupVault(
        recoveryPointArn.map(value => value),
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        sourceBackupVaultArn.map(value => value),
        resourceArn.map(value => value),
        resourceType.map(value => value),
        createdBy.map(value => value.asEditable),
        iamRoleArn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationDate.map(value => value),
        completionDate.map(value => value),
        backupSizeInBytes.map(value => value),
        calculatedLifecycle.map(value => value.asEditable),
        lifecycle.map(value => value.asEditable),
        encryptionKeyArn.map(value => value),
        isEncrypted.map(value => value),
        lastRestoreTime.map(value => value),
        parentRecoveryPointArn.map(value => value),
        compositeMemberIdentifier.map(value => value),
        isParent.map(value => value)
      )
    def recoveryPointArn: Optional[ARN]
    def backupVaultName: Optional[BackupVaultName]
    def backupVaultArn: Optional[ARN]
    def sourceBackupVaultArn: Optional[ARN]
    def resourceArn: Optional[ARN]
    def resourceType: Optional[ResourceType]
    def createdBy: Optional[zio.aws.backup.model.RecoveryPointCreator.ReadOnly]
    def iamRoleArn: Optional[IAMRoleArn]
    def status: Optional[zio.aws.backup.model.RecoveryPointStatus]
    def statusMessage: Optional[String]
    def creationDate: Optional[Timestamp]
    def completionDate: Optional[Timestamp]
    def backupSizeInBytes: Optional[Long]
    def calculatedLifecycle
        : Optional[zio.aws.backup.model.CalculatedLifecycle.ReadOnly]
    def lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly]
    def encryptionKeyArn: Optional[ARN]
    def isEncrypted: Optional[Boolean]
    def lastRestoreTime: Optional[Timestamp]
    def parentRecoveryPointArn: Optional[ARN]
    def compositeMemberIdentifier: Optional[String]
    def isParent: Optional[Boolean]
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getSourceBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("sourceBackupVaultArn", sourceBackupVaultArn)
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointCreator.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.backup.model.RecoveryPointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getCalculatedLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.CalculatedLifecycle.ReadOnly
    ] = AwsError.unwrapOptionField("calculatedLifecycle", calculatedLifecycle)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getIsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEncrypted", isEncrypted)
    def getLastRestoreTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastRestoreTime", lastRestoreTime)
    def getParentRecoveryPointArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("parentRecoveryPointArn", parentRecoveryPointArn)
    def getCompositeMemberIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("compositeMemberIdentifier", compositeMemberIdentifier)
    def getIsParent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isParent", isParent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
  ) extends zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly {
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val sourceBackupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val createdBy
        : Optional[zio.aws.backup.model.RecoveryPointCreator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.backup.model.RecoveryPointCreator.wrap(value))
    override val iamRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val status: Optional[zio.aws.backup.model.RecoveryPointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.backup.model.RecoveryPointStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val backupSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSizeInBytes())
      .map(value => value: Long)
    override val calculatedLifecycle
        : Optional[zio.aws.backup.model.CalculatedLifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calculatedLifecycle())
        .map(value => zio.aws.backup.model.CalculatedLifecycle.wrap(value))
    override val lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val encryptionKeyArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKeyArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val isEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEncrypted())
      .map(value => value: Boolean)
    override val lastRestoreTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRestoreTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val parentRecoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.parentRecoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val compositeMemberIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compositeMemberIdentifier())
        .map(value => value: String)
    override val isParent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isParent())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault
  ): zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly = new Wrapper(
    impl
  )
}
