package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportSetting(
    reportTemplate: String,
    frameworkArns: Optional[Iterable[String]] = Optional.Absent,
    numberOfFrameworks: Optional[Integer] = Optional.Absent,
    accounts: Optional[Iterable[String]] = Optional.Absent,
    organizationUnits: Optional[Iterable[String]] = Optional.Absent,
    regions: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ReportSetting = {
    import ReportSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ReportSetting
      .builder()
      .reportTemplate(reportTemplate: java.lang.String)
      .optionallyWith(
        frameworkArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.frameworkArns)
      .optionallyWith(
        numberOfFrameworks.map(value => value: java.lang.Integer)
      )(_.numberOfFrameworks)
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        organizationUnits.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.organizationUnits)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ReportSetting.ReadOnly =
    zio.aws.backup.model.ReportSetting.wrap(buildAwsValue())
}
object ReportSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ReportSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ReportSetting =
      zio.aws.backup.model.ReportSetting(
        reportTemplate,
        frameworkArns.map(value => value),
        numberOfFrameworks.map(value => value),
        accounts.map(value => value),
        organizationUnits.map(value => value),
        regions.map(value => value)
      )
    def reportTemplate: String
    def frameworkArns: Optional[List[String]]
    def numberOfFrameworks: Optional[Integer]
    def accounts: Optional[List[String]]
    def organizationUnits: Optional[List[String]]
    def regions: Optional[List[String]]
    def getReportTemplate: ZIO[Any, Nothing, String] =
      ZIO.succeed(reportTemplate)
    def getFrameworkArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("frameworkArns", frameworkArns)
    def getNumberOfFrameworks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfFrameworks", numberOfFrameworks)
    def getAccounts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getOrganizationUnits: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("organizationUnits", organizationUnits)
    def getRegions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ReportSetting
  ) extends zio.aws.backup.model.ReportSetting.ReadOnly {
    override val reportTemplate: String = impl.reportTemplate(): String
    override val frameworkArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val numberOfFrameworks: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfFrameworks())
      .map(value => value: Integer)
    override val accounts: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val organizationUnits: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationUnits())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val regions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ReportSetting
  ): zio.aws.backup.model.ReportSetting.ReadOnly = new Wrapper(impl)
}
