package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait LegalHoldStatus {
  def unwrap: software.amazon.awssdk.services.backup.model.LegalHoldStatus
}
object LegalHoldStatus {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.LegalHoldStatus
  ): zio.aws.backup.model.LegalHoldStatus = value match {
    case software.amazon.awssdk.services.backup.model.LegalHoldStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.LegalHoldStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.backup.model.LegalHoldStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.backup.model.LegalHoldStatus.CANCELING =>
      val r = CANCELING
      r
    case software.amazon.awssdk.services.backup.model.LegalHoldStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.LegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.LegalHoldStatus =
      software.amazon.awssdk.services.backup.model.LegalHoldStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.backup.model.LegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.LegalHoldStatus =
      software.amazon.awssdk.services.backup.model.LegalHoldStatus.CREATING
  }
  case object ACTIVE extends zio.aws.backup.model.LegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.LegalHoldStatus =
      software.amazon.awssdk.services.backup.model.LegalHoldStatus.ACTIVE
  }
  case object CANCELING extends zio.aws.backup.model.LegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.LegalHoldStatus =
      software.amazon.awssdk.services.backup.model.LegalHoldStatus.CANCELING
  }
  case object CANCELED extends zio.aws.backup.model.LegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.LegalHoldStatus =
      software.amazon.awssdk.services.backup.model.LegalHoldStatus.CANCELED
  }
}
