package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.BackupVaultName
import scala.jdk.CollectionConverters._
final case class DeleteBackupVaultAccessPolicyRequest(
    backupVaultName: BackupVaultName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest = {
    import DeleteBackupVaultAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.DeleteBackupVaultAccessPolicyRequest.ReadOnly =
    zio.aws.backup.model.DeleteBackupVaultAccessPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteBackupVaultAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupVaultAccessPolicyRequest =
      zio.aws.backup.model.DeleteBackupVaultAccessPolicyRequest(backupVaultName)
    def backupVaultName: BackupVaultName
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest
  ) extends zio.aws.backup.model.DeleteBackupVaultAccessPolicyRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest
  ): zio.aws.backup.model.DeleteBackupVaultAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
