package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DateRange(fromDate: Timestamp, toDate: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DateRange = {
    import DateRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DateRange
      .builder()
      .fromDate(Timestamp.unwrap(fromDate): Instant)
      .toDate(Timestamp.unwrap(toDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DateRange.ReadOnly =
    zio.aws.backup.model.DateRange.wrap(buildAwsValue())
}
object DateRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.DateRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DateRange =
      zio.aws.backup.model.DateRange(fromDate, toDate)
    def fromDate: Timestamp
    def toDate: Timestamp
    def getFromDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(fromDate)
    def getToDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(toDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DateRange
  ) extends zio.aws.backup.model.DateRange.ReadOnly {
    override val fromDate: Timestamp =
      zio.aws.backup.model.primitives.Timestamp(impl.fromDate())
    override val toDate: Timestamp =
      zio.aws.backup.model.primitives.Timestamp(impl.toDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DateRange
  ): zio.aws.backup.model.DateRange.ReadOnly = new Wrapper(impl)
}
