package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListReportPlansResponse(
    reportPlans: Optional[Iterable[zio.aws.backup.model.ReportPlan]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListReportPlansResponse = {
    import ListReportPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListReportPlansResponse
      .builder()
      .optionallyWith(
        reportPlans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reportPlans)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListReportPlansResponse.ReadOnly =
    zio.aws.backup.model.ListReportPlansResponse.wrap(buildAwsValue())
}
object ListReportPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListReportPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListReportPlansResponse =
      zio.aws.backup.model.ListReportPlansResponse(
        reportPlans.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def reportPlans: Optional[List[zio.aws.backup.model.ReportPlan.ReadOnly]]
    def nextToken: Optional[String]
    def getReportPlans
        : ZIO[Any, AwsError, List[zio.aws.backup.model.ReportPlan.ReadOnly]] =
      AwsError.unwrapOptionField("reportPlans", reportPlans)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListReportPlansResponse
  ) extends zio.aws.backup.model.ListReportPlansResponse.ReadOnly {
    override val reportPlans
        : Optional[List[zio.aws.backup.model.ReportPlan.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportPlans())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ReportPlan.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListReportPlansResponse
  ): zio.aws.backup.model.ListReportPlansResponse.ReadOnly = new Wrapper(impl)
}
