package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBackupSelectionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    backupSelectionsList: Optional[
      Iterable[zio.aws.backup.model.BackupSelectionsListMember]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse = {
    import ListBackupSelectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        backupSelectionsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupSelectionsList)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly =
    zio.aws.backup.model.ListBackupSelectionsResponse.wrap(buildAwsValue())
}
object ListBackupSelectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupSelectionsResponse =
      zio.aws.backup.model.ListBackupSelectionsResponse(
        nextToken.map(value => value),
        backupSelectionsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def backupSelectionsList: Optional[
      List[zio.aws.backup.model.BackupSelectionsListMember.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBackupSelectionsList: ZIO[Any, AwsError, List[
      zio.aws.backup.model.BackupSelectionsListMember.ReadOnly
    ]] =
      AwsError.unwrapOptionField("backupSelectionsList", backupSelectionsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse
  ) extends zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val backupSelectionsList: Optional[
      List[zio.aws.backup.model.BackupSelectionsListMember.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSelectionsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.BackupSelectionsListMember.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse
  ): zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
