package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CalculatedLifecycle(
    moveToColdStorageAt: Optional[Timestamp] = Optional.Absent,
    deleteAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CalculatedLifecycle = {
    import CalculatedLifecycle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CalculatedLifecycle
      .builder()
      .optionallyWith(
        moveToColdStorageAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.moveToColdStorageAt)
      .optionallyWith(deleteAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deleteAt
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CalculatedLifecycle.ReadOnly =
    zio.aws.backup.model.CalculatedLifecycle.wrap(buildAwsValue())
}
object CalculatedLifecycle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CalculatedLifecycle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CalculatedLifecycle =
      zio.aws.backup.model.CalculatedLifecycle(
        moveToColdStorageAt.map(value => value),
        deleteAt.map(value => value)
      )
    def moveToColdStorageAt: Optional[Timestamp]
    def deleteAt: Optional[Timestamp]
    def getMoveToColdStorageAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("moveToColdStorageAt", moveToColdStorageAt)
    def getDeleteAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deleteAt", deleteAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CalculatedLifecycle
  ) extends zio.aws.backup.model.CalculatedLifecycle.ReadOnly {
    override val moveToColdStorageAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moveToColdStorageAt())
        .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deleteAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteAt())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CalculatedLifecycle
  ): zio.aws.backup.model.CalculatedLifecycle.ReadOnly = new Wrapper(impl)
}
