package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ReportJobId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartReportJobResponse(
    reportJobId: Optional[ReportJobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartReportJobResponse = {
    import StartReportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartReportJobResponse
      .builder()
      .optionallyWith(
        reportJobId.map(value => ReportJobId.unwrap(value): java.lang.String)
      )(_.reportJobId)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartReportJobResponse.ReadOnly =
    zio.aws.backup.model.StartReportJobResponse.wrap(buildAwsValue())
}
object StartReportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartReportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartReportJobResponse =
      zio.aws.backup.model
        .StartReportJobResponse(reportJobId.map(value => value))
    def reportJobId: Optional[ReportJobId]
    def getReportJobId: ZIO[Any, AwsError, ReportJobId] =
      AwsError.unwrapOptionField("reportJobId", reportJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartReportJobResponse
  ) extends zio.aws.backup.model.StartReportJobResponse.ReadOnly {
    override val reportJobId: Optional[ReportJobId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportJobId())
      .map(value => zio.aws.backup.model.primitives.ReportJobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartReportJobResponse
  ): zio.aws.backup.model.StartReportJobResponse.ReadOnly = new Wrapper(impl)
}
