package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, AccountId, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRestoreJobsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    byAccountId: Optional[AccountId] = Optional.Absent,
    byCreatedBefore: Optional[Timestamp] = Optional.Absent,
    byCreatedAfter: Optional[Timestamp] = Optional.Absent,
    byStatus: Optional[zio.aws.backup.model.RestoreJobStatus] = Optional.Absent,
    byCompleteBefore: Optional[Timestamp] = Optional.Absent,
    byCompleteAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest = {
    import ListRestoreJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.byAccountId)
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .optionallyWith(byStatus.map(value => value.unwrap))(_.byStatus)
      .optionallyWith(
        byCompleteBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCompleteBefore)
      .optionallyWith(
        byCompleteAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCompleteAfter)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListRestoreJobsRequest.ReadOnly =
    zio.aws.backup.model.ListRestoreJobsRequest.wrap(buildAwsValue())
}
object ListRestoreJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRestoreJobsRequest =
      zio.aws.backup.model.ListRestoreJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        byAccountId.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value),
        byStatus.map(value => value),
        byCompleteBefore.map(value => value),
        byCompleteAfter.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def byAccountId: Optional[AccountId]
    def byCreatedBefore: Optional[Timestamp]
    def byCreatedAfter: Optional[Timestamp]
    def byStatus: Optional[zio.aws.backup.model.RestoreJobStatus]
    def byCompleteBefore: Optional[Timestamp]
    def byCompleteAfter: Optional[Timestamp]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("byAccountId", byAccountId)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
    def getByStatus: ZIO[Any, AwsError, zio.aws.backup.model.RestoreJobStatus] =
      AwsError.unwrapOptionField("byStatus", byStatus)
    def getByCompleteBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCompleteBefore", byCompleteBefore)
    def getByCompleteAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCompleteAfter", byCompleteAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
  ) extends zio.aws.backup.model.ListRestoreJobsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.byAccountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val byCreatedBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byStatus: Optional[zio.aws.backup.model.RestoreJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byStatus())
        .map(value => zio.aws.backup.model.RestoreJobStatus.wrap(value))
    override val byCompleteBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCompleteBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCompleteAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCompleteAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest
  ): zio.aws.backup.model.ListRestoreJobsRequest.ReadOnly = new Wrapper(impl)
}
