package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetBackupPlanResponse(
    backupPlan: Optional[zio.aws.backup.model.BackupPlan] = Optional.Absent,
    backupPlanId: Optional[String] = Optional.Absent,
    backupPlanArn: Optional[ARN] = Optional.Absent,
    versionId: Optional[String] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    deletionDate: Optional[Timestamp] = Optional.Absent,
    lastExecutionDate: Optional[Timestamp] = Optional.Absent,
    advancedBackupSettings: Optional[
      Iterable[zio.aws.backup.model.AdvancedBackupSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupPlanResponse = {
    import GetBackupPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupPlanResponse
      .builder()
      .optionallyWith(backupPlan.map(value => value.buildAwsValue()))(
        _.backupPlan
      )
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        backupPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupPlanArn)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        deletionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(
        lastExecutionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.advancedBackupSettings)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetBackupPlanResponse.ReadOnly =
    zio.aws.backup.model.GetBackupPlanResponse.wrap(buildAwsValue())
}
object GetBackupPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupPlanResponse =
      zio.aws.backup.model.GetBackupPlanResponse(
        backupPlan.map(value => value.asEditable),
        backupPlanId.map(value => value),
        backupPlanArn.map(value => value),
        versionId.map(value => value),
        creatorRequestId.map(value => value),
        creationDate.map(value => value),
        deletionDate.map(value => value),
        lastExecutionDate.map(value => value),
        advancedBackupSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPlan: Optional[zio.aws.backup.model.BackupPlan.ReadOnly]
    def backupPlanId: Optional[String]
    def backupPlanArn: Optional[ARN]
    def versionId: Optional[String]
    def creatorRequestId: Optional[String]
    def creationDate: Optional[Timestamp]
    def deletionDate: Optional[Timestamp]
    def lastExecutionDate: Optional[Timestamp]
    def advancedBackupSettings
        : Optional[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]]
    def getBackupPlan
        : ZIO[Any, AwsError, zio.aws.backup.model.BackupPlan.ReadOnly] =
      AwsError.unwrapOptionField("backupPlan", backupPlan)
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getBackupPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDeletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getLastExecutionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getAdvancedBackupSettings: ZIO[Any, AwsError, List[
      zio.aws.backup.model.AdvancedBackupSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "advancedBackupSettings",
      advancedBackupSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanResponse
  ) extends zio.aws.backup.model.GetBackupPlanResponse.ReadOnly {
    override val backupPlan
        : Optional[zio.aws.backup.model.BackupPlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlan())
        .map(value => zio.aws.backup.model.BackupPlan.wrap(value))
    override val backupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => value: String)
    override val backupPlanArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val versionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => value: String)
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deletionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val lastExecutionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastExecutionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val advancedBackupSettings
        : Optional[List[zio.aws.backup.model.AdvancedBackupSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedBackupSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.AdvancedBackupSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanResponse
  ): zio.aws.backup.model.GetBackupPlanResponse.ReadOnly = new Wrapper(impl)
}
