package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BackupPlanTemplatesListMember(
    backupPlanTemplateId: Optional[String] = Optional.Absent,
    backupPlanTemplateName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember = {
    import BackupPlanTemplatesListMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember
      .builder()
      .optionallyWith(
        backupPlanTemplateId.map(value => value: java.lang.String)
      )(_.backupPlanTemplateId)
      .optionallyWith(
        backupPlanTemplateName.map(value => value: java.lang.String)
      )(_.backupPlanTemplateName)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly =
    zio.aws.backup.model.BackupPlanTemplatesListMember.wrap(buildAwsValue())
}
object BackupPlanTemplatesListMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupPlanTemplatesListMember =
      zio.aws.backup.model.BackupPlanTemplatesListMember(
        backupPlanTemplateId.map(value => value),
        backupPlanTemplateName.map(value => value)
      )
    def backupPlanTemplateId: Optional[String]
    def backupPlanTemplateName: Optional[String]
    def getBackupPlanTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanTemplateId", backupPlanTemplateId)
    def getBackupPlanTemplateName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("backupPlanTemplateName", backupPlanTemplateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember
  ) extends zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly {
    override val backupPlanTemplateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanTemplateId())
      .map(value => value: String)
    override val backupPlanTemplateName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanTemplateName())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember
  ): zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly = new Wrapper(
    impl
  )
}
