package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  AccountId,
  Timestamp,
  ResourceType,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RestoreJobsListMember(
    accountId: Optional[AccountId] = Optional.Absent,
    restoreJobId: Optional[String] = Optional.Absent,
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    completionDate: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.backup.model.RestoreJobStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    percentDone: Optional[String] = Optional.Absent,
    backupSizeInBytes: Optional[Long] = Optional.Absent,
    iamRoleArn: Optional[IAMRoleArn] = Optional.Absent,
    expectedCompletionTimeMinutes: Optional[Long] = Optional.Absent,
    createdResourceArn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RestoreJobsListMember = {
    import RestoreJobsListMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RestoreJobsListMember
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(restoreJobId.map(value => value: java.lang.String))(
        _.restoreJobId
      )
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(percentDone.map(value => value: java.lang.String))(
        _.percentDone
      )
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        expectedCompletionTimeMinutes.map(value => value: java.lang.Long)
      )(_.expectedCompletionTimeMinutes)
      .optionallyWith(
        createdResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.createdResourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RestoreJobsListMember.ReadOnly =
    zio.aws.backup.model.RestoreJobsListMember.wrap(buildAwsValue())
}
object RestoreJobsListMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RestoreJobsListMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RestoreJobsListMember =
      zio.aws.backup.model.RestoreJobsListMember(
        accountId.map(value => value),
        restoreJobId.map(value => value),
        recoveryPointArn.map(value => value),
        creationDate.map(value => value),
        completionDate.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        percentDone.map(value => value),
        backupSizeInBytes.map(value => value),
        iamRoleArn.map(value => value),
        expectedCompletionTimeMinutes.map(value => value),
        createdResourceArn.map(value => value),
        resourceType.map(value => value)
      )
    def accountId: Optional[AccountId]
    def restoreJobId: Optional[String]
    def recoveryPointArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def completionDate: Optional[Timestamp]
    def status: Optional[zio.aws.backup.model.RestoreJobStatus]
    def statusMessage: Optional[String]
    def percentDone: Optional[String]
    def backupSizeInBytes: Optional[Long]
    def iamRoleArn: Optional[IAMRoleArn]
    def expectedCompletionTimeMinutes: Optional[Long]
    def createdResourceArn: Optional[ARN]
    def resourceType: Optional[ResourceType]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRestoreJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreJobId", restoreJobId)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getStatus: ZIO[Any, AwsError, zio.aws.backup.model.RestoreJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPercentDone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentDone", percentDone)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getExpectedCompletionTimeMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "expectedCompletionTimeMinutes",
        expectedCompletionTimeMinutes
      )
    def getCreatedResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("createdResourceArn", createdResourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RestoreJobsListMember
  ) extends zio.aws.backup.model.RestoreJobsListMember.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val restoreJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreJobId())
      .map(value => value: String)
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.backup.model.RestoreJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.backup.model.RestoreJobStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val percentDone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.percentDone())
      .map(value => value: String)
    override val backupSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSizeInBytes())
      .map(value => value: Long)
    override val iamRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val expectedCompletionTimeMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedCompletionTimeMinutes())
        .map(value => value: Long)
    override val createdResourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.createdResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RestoreJobsListMember
  ): zio.aws.backup.model.RestoreJobsListMember.ReadOnly = new Wrapper(impl)
}
