package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{BackupVaultName, Timestamp, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RecoveryPointByResource(
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.backup.model.RecoveryPointStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    encryptionKeyArn: Optional[ARN] = Optional.Absent,
    backupSizeBytes: Optional[Long] = Optional.Absent,
    backupVaultName: Optional[BackupVaultName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointByResource = {
    import RecoveryPointByResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointByResource
      .builder()
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        encryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .optionallyWith(backupSizeBytes.map(value => value: java.lang.Long))(
        _.backupSizeBytes
      )
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointByResource.ReadOnly =
    zio.aws.backup.model.RecoveryPointByResource.wrap(buildAwsValue())
}
object RecoveryPointByResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointByResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointByResource =
      zio.aws.backup.model.RecoveryPointByResource(
        recoveryPointArn.map(value => value),
        creationDate.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        encryptionKeyArn.map(value => value),
        backupSizeBytes.map(value => value),
        backupVaultName.map(value => value)
      )
    def recoveryPointArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def status: Optional[zio.aws.backup.model.RecoveryPointStatus]
    def statusMessage: Optional[String]
    def encryptionKeyArn: Optional[ARN]
    def backupSizeBytes: Optional[Long]
    def backupVaultName: Optional[BackupVaultName]
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.backup.model.RecoveryPointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getBackupSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeBytes", backupSizeBytes)
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointByResource
  ) extends zio.aws.backup.model.RecoveryPointByResource.ReadOnly {
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.backup.model.RecoveryPointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.backup.model.RecoveryPointStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val encryptionKeyArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKeyArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupSizeBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSizeBytes())
      .map(value => value: Long)
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointByResource
  ): zio.aws.backup.model.RecoveryPointByResource.ReadOnly = new Wrapper(impl)
}
