package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.BackupVaultName
import scala.jdk.CollectionConverters._
final case class DeleteBackupVaultLockConfigurationRequest(
    backupVaultName: BackupVaultName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest = {
    import DeleteBackupVaultLockConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.DeleteBackupVaultLockConfigurationRequest.ReadOnly =
    zio.aws.backup.model.DeleteBackupVaultLockConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBackupVaultLockConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.DeleteBackupVaultLockConfigurationRequest =
      zio.aws.backup.model
        .DeleteBackupVaultLockConfigurationRequest(backupVaultName)
    def backupVaultName: BackupVaultName
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest
  ) extends zio.aws.backup.model.DeleteBackupVaultLockConfigurationRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest
  ): zio.aws.backup.model.DeleteBackupVaultLockConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
