package zio.aws.backup.model
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.MaxFrameworkInputs
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListFrameworksRequest(
    maxResults: Optional[MaxFrameworkInputs] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListFrameworksRequest = {
    import ListFrameworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListFrameworksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxFrameworkInputs.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListFrameworksRequest.ReadOnly =
    zio.aws.backup.model.ListFrameworksRequest.wrap(buildAwsValue())
}
object ListFrameworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListFrameworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListFrameworksRequest =
      zio.aws.backup.model.ListFrameworksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxFrameworkInputs]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, MaxFrameworkInputs] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListFrameworksRequest
  ) extends zio.aws.backup.model.ListFrameworksRequest.ReadOnly {
    override val maxResults: Optional[MaxFrameworkInputs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.backup.model.primitives.MaxFrameworkInputs(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListFrameworksRequest
  ): zio.aws.backup.model.ListFrameworksRequest.ReadOnly = new Wrapper(impl)
}
