package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ARN,
    tagKeyList: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UntagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tagKeyList(tagKeyList.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UntagResourceRequest.ReadOnly =
    zio.aws.backup.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UntagResourceRequest =
      zio.aws.backup.model.UntagResourceRequest(resourceArn, tagKeyList)
    def resourceArn: ARN
    def tagKeyList: List[String]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTagKeyList: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeyList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UntagResourceRequest
  ) extends zio.aws.backup.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.resourceArn())
    override val tagKeyList: List[String] = impl
      .tagKeyList()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UntagResourceRequest
  ): zio.aws.backup.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
