package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBackupPlanVersionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    backupPlanVersionsList: Optional[
      Iterable[zio.aws.backup.model.BackupPlansListMember]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse = {
    import ListBackupPlanVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        backupPlanVersionsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupPlanVersionsList)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly =
    zio.aws.backup.model.ListBackupPlanVersionsResponse.wrap(buildAwsValue())
}
object ListBackupPlanVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlanVersionsResponse =
      zio.aws.backup.model.ListBackupPlanVersionsResponse(
        nextToken.map(value => value),
        backupPlanVersionsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def backupPlanVersionsList
        : Optional[List[zio.aws.backup.model.BackupPlansListMember.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBackupPlanVersionsList: ZIO[Any, AwsError, List[
      zio.aws.backup.model.BackupPlansListMember.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backupPlanVersionsList",
      backupPlanVersionsList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse
  ) extends zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val backupPlanVersionsList
        : Optional[List[zio.aws.backup.model.BackupPlansListMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanVersionsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.BackupPlansListMember.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse
  ): zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
