package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBackupVaultNotificationsResponse(
    backupVaultName: Optional[BackupVaultName] = Optional.Absent,
    backupVaultArn: Optional[ARN] = Optional.Absent,
    snsTopicArn: Optional[ARN] = Optional.Absent,
    backupVaultEvents: Optional[
      Iterable[zio.aws.backup.model.BackupVaultEvent]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse = {
    import GetBackupVaultNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
      .builder()
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        snsTopicArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        backupVaultEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.backupVaultEventsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly =
    zio.aws.backup.model.GetBackupVaultNotificationsResponse
      .wrap(buildAwsValue())
}
object GetBackupVaultNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupVaultNotificationsResponse =
      zio.aws.backup.model.GetBackupVaultNotificationsResponse(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        snsTopicArn.map(value => value),
        backupVaultEvents.map(value => value)
      )
    def backupVaultName: Optional[BackupVaultName]
    def backupVaultArn: Optional[ARN]
    def snsTopicArn: Optional[ARN]
    def backupVaultEvents: Optional[List[zio.aws.backup.model.BackupVaultEvent]]
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getSnsTopicArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getBackupVaultEvents
        : ZIO[Any, AwsError, List[zio.aws.backup.model.BackupVaultEvent]] =
      AwsError.unwrapOptionField("backupVaultEvents", backupVaultEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
  ) extends zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly {
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val snsTopicArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupVaultEvents
        : Optional[List[zio.aws.backup.model.BackupVaultEvent]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.BackupVaultEvent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse
  ): zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly =
    new Wrapper(impl)
}
