package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackupSelectionRequest(
    backupPlanId: String,
    backupSelection: zio.aws.backup.model.BackupSelection,
    creatorRequestId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest = {
    import CreateBackupSelectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest
      .builder()
      .backupPlanId(backupPlanId: java.lang.String)
      .backupSelection(backupSelection.buildAwsValue())
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateBackupSelectionRequest.ReadOnly =
    zio.aws.backup.model.CreateBackupSelectionRequest.wrap(buildAwsValue())
}
object CreateBackupSelectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateBackupSelectionRequest =
      zio.aws.backup.model.CreateBackupSelectionRequest(
        backupPlanId,
        backupSelection.asEditable,
        creatorRequestId.map(value => value)
      )
    def backupPlanId: String
    def backupSelection: zio.aws.backup.model.BackupSelection.ReadOnly
    def creatorRequestId: Optional[String]
    def getBackupPlanId: ZIO[Any, Nothing, String] = ZIO.succeed(backupPlanId)
    def getBackupSelection
        : ZIO[Any, Nothing, zio.aws.backup.model.BackupSelection.ReadOnly] =
      ZIO.succeed(backupSelection)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest
  ) extends zio.aws.backup.model.CreateBackupSelectionRequest.ReadOnly {
    override val backupPlanId: String = impl.backupPlanId(): String
    override val backupSelection
        : zio.aws.backup.model.BackupSelection.ReadOnly =
      zio.aws.backup.model.BackupSelection.wrap(impl.backupSelection())
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest
  ): zio.aws.backup.model.CreateBackupSelectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
