package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecoveryPointCreator(
    backupPlanId: Optional[String] = Optional.Absent,
    backupPlanArn: Optional[ARN] = Optional.Absent,
    backupPlanVersion: Optional[String] = Optional.Absent,
    backupRuleId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointCreator = {
    import RecoveryPointCreator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointCreator
      .builder()
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        backupPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupPlanArn)
      .optionallyWith(backupPlanVersion.map(value => value: java.lang.String))(
        _.backupPlanVersion
      )
      .optionallyWith(backupRuleId.map(value => value: java.lang.String))(
        _.backupRuleId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointCreator.ReadOnly =
    zio.aws.backup.model.RecoveryPointCreator.wrap(buildAwsValue())
}
object RecoveryPointCreator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointCreator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointCreator =
      zio.aws.backup.model.RecoveryPointCreator(
        backupPlanId.map(value => value),
        backupPlanArn.map(value => value),
        backupPlanVersion.map(value => value),
        backupRuleId.map(value => value)
      )
    def backupPlanId: Optional[String]
    def backupPlanArn: Optional[ARN]
    def backupPlanVersion: Optional[String]
    def backupRuleId: Optional[String]
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getBackupPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getBackupPlanVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanVersion", backupPlanVersion)
    def getBackupRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupRuleId", backupRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointCreator
  ) extends zio.aws.backup.model.RecoveryPointCreator.ReadOnly {
    override val backupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => value: String)
    override val backupPlanArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val backupPlanVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanVersion())
      .map(value => value: String)
    override val backupRuleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupRuleId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointCreator
  ): zio.aws.backup.model.RecoveryPointCreator.ReadOnly = new Wrapper(impl)
}
