package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeBackupJobRequest(backupJobId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest = {
    import DescribeBackupJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest
      .builder()
      .backupJobId(backupJobId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeBackupJobRequest.ReadOnly =
    zio.aws.backup.model.DescribeBackupJobRequest.wrap(buildAwsValue())
}
object DescribeBackupJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeBackupJobRequest =
      zio.aws.backup.model.DescribeBackupJobRequest(backupJobId)
    def backupJobId: String
    def getBackupJobId: ZIO[Any, Nothing, String] = ZIO.succeed(backupJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest
  ) extends zio.aws.backup.model.DescribeBackupJobRequest.ReadOnly {
    override val backupJobId: String = impl.backupJobId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest
  ): zio.aws.backup.model.DescribeBackupJobRequest.ReadOnly = new Wrapper(impl)
}
