package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.BackupVaultName
import scala.jdk.CollectionConverters._
final case class DeleteBackupVaultNotificationsRequest(
    backupVaultName: BackupVaultName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest = {
    import DeleteBackupVaultNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.DeleteBackupVaultNotificationsRequest.ReadOnly =
    zio.aws.backup.model.DeleteBackupVaultNotificationsRequest
      .wrap(buildAwsValue())
}
object DeleteBackupVaultNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupVaultNotificationsRequest =
      zio.aws.backup.model
        .DeleteBackupVaultNotificationsRequest(backupVaultName)
    def backupVaultName: BackupVaultName
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest
  ) extends zio.aws.backup.model.DeleteBackupVaultNotificationsRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest
  ): zio.aws.backup.model.DeleteBackupVaultNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
