package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFrameworksResponse(
    frameworks: Optional[Iterable[zio.aws.backup.model.Framework]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListFrameworksResponse = {
    import ListFrameworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListFrameworksResponse
      .builder()
      .optionallyWith(
        frameworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListFrameworksResponse.ReadOnly =
    zio.aws.backup.model.ListFrameworksResponse.wrap(buildAwsValue())
}
object ListFrameworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListFrameworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListFrameworksResponse =
      zio.aws.backup.model.ListFrameworksResponse(
        frameworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def frameworks: Optional[List[zio.aws.backup.model.Framework.ReadOnly]]
    def nextToken: Optional[String]
    def getFrameworks
        : ZIO[Any, AwsError, List[zio.aws.backup.model.Framework.ReadOnly]] =
      AwsError.unwrapOptionField("frameworks", frameworks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListFrameworksResponse
  ) extends zio.aws.backup.model.ListFrameworksResponse.ReadOnly {
    override val frameworks
        : Optional[List[zio.aws.backup.model.Framework.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.Framework.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListFrameworksResponse
  ): zio.aws.backup.model.ListFrameworksResponse.ReadOnly = new Wrapper(impl)
}
