package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{FrameworkDescription, FrameworkName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFrameworkRequest(
    frameworkName: FrameworkName,
    frameworkDescription: Optional[FrameworkDescription] = Optional.Absent,
    frameworkControls: Optional[
      Iterable[zio.aws.backup.model.FrameworkControl]
    ] = Optional.Absent,
    idempotencyToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest = {
    import UpdateFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest
      .builder()
      .frameworkName(FrameworkName.unwrap(frameworkName): java.lang.String)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(
        frameworkControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworkControls)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateFrameworkRequest.ReadOnly =
    zio.aws.backup.model.UpdateFrameworkRequest.wrap(buildAwsValue())
}
object UpdateFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateFrameworkRequest =
      zio.aws.backup.model.UpdateFrameworkRequest(
        frameworkName,
        frameworkDescription.map(value => value),
        frameworkControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        idempotencyToken.map(value => value)
      )
    def frameworkName: FrameworkName
    def frameworkDescription: Optional[FrameworkDescription]
    def frameworkControls
        : Optional[List[zio.aws.backup.model.FrameworkControl.ReadOnly]]
    def idempotencyToken: Optional[String]
    def getFrameworkName: ZIO[Any, Nothing, FrameworkName] =
      ZIO.succeed(frameworkName)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getFrameworkControls: ZIO[Any, AwsError, List[
      zio.aws.backup.model.FrameworkControl.ReadOnly
    ]] = AwsError.unwrapOptionField("frameworkControls", frameworkControls)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest
  ) extends zio.aws.backup.model.UpdateFrameworkRequest.ReadOnly {
    override val frameworkName: FrameworkName =
      zio.aws.backup.model.primitives.FrameworkName(impl.frameworkName())
    override val frameworkDescription: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkDescription())
        .map(value =>
          zio.aws.backup.model.primitives.FrameworkDescription(value)
        )
    override val frameworkControls
        : Optional[List[zio.aws.backup.model.FrameworkControl.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkControls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.FrameworkControl.wrap(item)
          }.toList
        )
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest
  ): zio.aws.backup.model.UpdateFrameworkRequest.ReadOnly = new Wrapper(impl)
}
