package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ControlScope(
    complianceResourceIds: Optional[Iterable[String]] = Optional.Absent,
    complianceResourceTypes: Optional[Iterable[ARN]] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ControlScope = {
    import ControlScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ControlScope
      .builder()
      .optionallyWith(
        complianceResourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.complianceResourceIds)
      .optionallyWith(
        complianceResourceTypes.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.complianceResourceTypes)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ControlScope.ReadOnly =
    zio.aws.backup.model.ControlScope.wrap(buildAwsValue())
}
object ControlScope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ControlScope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ControlScope =
      zio.aws.backup.model.ControlScope(
        complianceResourceIds.map(value => value),
        complianceResourceTypes.map(value => value),
        tags.map(value => value)
      )
    def complianceResourceIds: Optional[List[String]]
    def complianceResourceTypes: Optional[List[ARN]]
    def tags: Optional[Map[String, String]]
    def getComplianceResourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("complianceResourceIds", complianceResourceIds)
    def getComplianceResourceTypes: ZIO[Any, AwsError, List[ARN]] = AwsError
      .unwrapOptionField("complianceResourceTypes", complianceResourceTypes)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ControlScope
  ) extends zio.aws.backup.model.ControlScope.ReadOnly {
    override val complianceResourceIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceResourceIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val complianceResourceTypes: Optional[List[ARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceResourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.primitives.ARN(item)
          }.toList
        )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ControlScope
  ): zio.aws.backup.model.ControlScope.ReadOnly = new Wrapper(impl)
}
