package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{MetadataValue, MetadataKey, ARN}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRecoveryPointRestoreMetadataResponse(
    backupVaultArn: Optional[ARN] = Optional.Absent,
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    restoreMetadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse = {
    import GetRecoveryPointRestoreMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
      .builder()
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        restoreMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.restoreMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly =
    zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse
      .wrap(buildAwsValue())
}
object GetRecoveryPointRestoreMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse =
      zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse(
        backupVaultArn.map(value => value),
        recoveryPointArn.map(value => value),
        restoreMetadata.map(value => value)
      )
    def backupVaultArn: Optional[ARN]
    def recoveryPointArn: Optional[ARN]
    def restoreMetadata: Optional[Map[MetadataKey, MetadataValue]]
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getRestoreMetadata
        : ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("restoreMetadata", restoreMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
  ) extends zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly {
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val restoreMetadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives.MetadataKey(
                key
              ) -> zio.aws.backup.model.primitives.MetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse
  ): zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
