package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{GlobalSettingsValue, GlobalSettingsName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGlobalSettingsRequest(
    globalSettings: Optional[Map[GlobalSettingsName, GlobalSettingsValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest = {
    import UpdateGlobalSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest
      .builder()
      .optionallyWith(
        globalSettings.map(value =>
          value
            .map({ case (key, value) =>
              (GlobalSettingsName
                .unwrap(key): java.lang.String) -> (GlobalSettingsValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.globalSettings)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateGlobalSettingsRequest.ReadOnly =
    zio.aws.backup.model.UpdateGlobalSettingsRequest.wrap(buildAwsValue())
}
object UpdateGlobalSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateGlobalSettingsRequest =
      zio.aws.backup.model
        .UpdateGlobalSettingsRequest(globalSettings.map(value => value))
    def globalSettings: Optional[Map[GlobalSettingsName, GlobalSettingsValue]]
    def getGlobalSettings
        : ZIO[Any, AwsError, Map[GlobalSettingsName, GlobalSettingsValue]] =
      AwsError.unwrapOptionField("globalSettings", globalSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest
  ) extends zio.aws.backup.model.UpdateGlobalSettingsRequest.ReadOnly {
    override val globalSettings
        : Optional[Map[GlobalSettingsName, GlobalSettingsValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSettings())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives.GlobalSettingsName(
                key
              ) -> zio.aws.backup.model.primitives.GlobalSettingsValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest
  ): zio.aws.backup.model.UpdateGlobalSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
