package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{TagValue, TagKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsResponse(
    nextToken: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListTagsResponse = {
    import ListTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListTagsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListTagsResponse.ReadOnly =
    zio.aws.backup.model.ListTagsResponse.wrap(buildAwsValue())
}
object ListTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListTagsResponse = zio.aws.backup.model
      .ListTagsResponse(nextToken.map(value => value), tags.map(value => value))
    def nextToken: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListTagsResponse
  ) extends zio.aws.backup.model.ListTagsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives
              .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListTagsResponse
  ): zio.aws.backup.model.ListTagsResponse.ReadOnly = new Wrapper(impl)
}
