package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  AccountId,
  Timestamp,
  ResourceType,
  MaxResults,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCopyJobsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    byResourceArn: Optional[ARN] = Optional.Absent,
    byState: Optional[zio.aws.backup.model.CopyJobState] = Optional.Absent,
    byCreatedBefore: Optional[Timestamp] = Optional.Absent,
    byCreatedAfter: Optional[Timestamp] = Optional.Absent,
    byResourceType: Optional[ResourceType] = Optional.Absent,
    byDestinationVaultArn: Optional[String] = Optional.Absent,
    byAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListCopyJobsRequest = {
    import ListCopyJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.byResourceArn)
      .optionallyWith(byState.map(value => value.unwrap))(_.byState)
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .optionallyWith(
        byResourceType.map(value =>
          ResourceType.unwrap(value): java.lang.String
        )
      )(_.byResourceType)
      .optionallyWith(
        byDestinationVaultArn.map(value => value: java.lang.String)
      )(_.byDestinationVaultArn)
      .optionallyWith(
        byAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.byAccountId)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListCopyJobsRequest.ReadOnly =
    zio.aws.backup.model.ListCopyJobsRequest.wrap(buildAwsValue())
}
object ListCopyJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListCopyJobsRequest =
      zio.aws.backup.model.ListCopyJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        byResourceArn.map(value => value),
        byState.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value),
        byResourceType.map(value => value),
        byDestinationVaultArn.map(value => value),
        byAccountId.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def byResourceArn: Optional[ARN]
    def byState: Optional[zio.aws.backup.model.CopyJobState]
    def byCreatedBefore: Optional[Timestamp]
    def byCreatedAfter: Optional[Timestamp]
    def byResourceType: Optional[ResourceType]
    def byDestinationVaultArn: Optional[String]
    def byAccountId: Optional[AccountId]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("byResourceArn", byResourceArn)
    def getByState: ZIO[Any, AwsError, zio.aws.backup.model.CopyJobState] =
      AwsError.unwrapOptionField("byState", byState)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
    def getByResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("byResourceType", byResourceType)
    def getByDestinationVaultArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("byDestinationVaultArn", byDestinationVaultArn)
    def getByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("byAccountId", byAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
  ) extends zio.aws.backup.model.ListCopyJobsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byResourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.byResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val byState: Optional[zio.aws.backup.model.CopyJobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byState())
        .map(value => zio.aws.backup.model.CopyJobState.wrap(value))
    override val byCreatedBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byResourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.byResourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val byDestinationVaultArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.byDestinationVaultArn())
      .map(value => value: String)
    override val byAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.byAccountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListCopyJobsRequest
  ): zio.aws.backup.model.ListCopyJobsRequest.ReadOnly = new Wrapper(impl)
}
