package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.RestoreJobId
import scala.jdk.CollectionConverters._
final case class DescribeRestoreJobRequest(restoreJobId: RestoreJobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest = {
    import DescribeRestoreJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest
      .builder()
      .restoreJobId(RestoreJobId.unwrap(restoreJobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeRestoreJobRequest.ReadOnly =
    zio.aws.backup.model.DescribeRestoreJobRequest.wrap(buildAwsValue())
}
object DescribeRestoreJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeRestoreJobRequest =
      zio.aws.backup.model.DescribeRestoreJobRequest(restoreJobId)
    def restoreJobId: RestoreJobId
    def getRestoreJobId: ZIO[Any, Nothing, RestoreJobId] =
      ZIO.succeed(restoreJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest
  ) extends zio.aws.backup.model.DescribeRestoreJobRequest.ReadOnly {
    override val restoreJobId: RestoreJobId =
      zio.aws.backup.model.primitives.RestoreJobId(impl.restoreJobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest
  ): zio.aws.backup.model.DescribeRestoreJobRequest.ReadOnly = new Wrapper(impl)
}
