package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  AccountId,
  Timestamp,
  BackupVaultName,
  ResourceType,
  MaxResults,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBackupJobsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    byResourceArn: Optional[ARN] = Optional.Absent,
    byState: Optional[zio.aws.backup.model.BackupJobState] = Optional.Absent,
    byBackupVaultName: Optional[BackupVaultName] = Optional.Absent,
    byCreatedBefore: Optional[Timestamp] = Optional.Absent,
    byCreatedAfter: Optional[Timestamp] = Optional.Absent,
    byResourceType: Optional[ResourceType] = Optional.Absent,
    byAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupJobsRequest = {
    import ListBackupJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupJobsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.byResourceArn)
      .optionallyWith(byState.map(value => value.unwrap))(_.byState)
      .optionallyWith(
        byBackupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.byBackupVaultName)
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .optionallyWith(
        byResourceType.map(value =>
          ResourceType.unwrap(value): java.lang.String
        )
      )(_.byResourceType)
      .optionallyWith(
        byAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.byAccountId)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupJobsRequest.ReadOnly =
    zio.aws.backup.model.ListBackupJobsRequest.wrap(buildAwsValue())
}
object ListBackupJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupJobsRequest =
      zio.aws.backup.model.ListBackupJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        byResourceArn.map(value => value),
        byState.map(value => value),
        byBackupVaultName.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value),
        byResourceType.map(value => value),
        byAccountId.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def byResourceArn: Optional[ARN]
    def byState: Optional[zio.aws.backup.model.BackupJobState]
    def byBackupVaultName: Optional[BackupVaultName]
    def byCreatedBefore: Optional[Timestamp]
    def byCreatedAfter: Optional[Timestamp]
    def byResourceType: Optional[ResourceType]
    def byAccountId: Optional[AccountId]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("byResourceArn", byResourceArn)
    def getByState: ZIO[Any, AwsError, zio.aws.backup.model.BackupJobState] =
      AwsError.unwrapOptionField("byState", byState)
    def getByBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("byBackupVaultName", byBackupVaultName)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
    def getByResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("byResourceType", byResourceType)
    def getByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("byAccountId", byAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupJobsRequest
  ) extends zio.aws.backup.model.ListBackupJobsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byResourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.byResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val byState: Optional[zio.aws.backup.model.BackupJobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byState())
        .map(value => zio.aws.backup.model.BackupJobState.wrap(value))
    override val byBackupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byBackupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val byCreatedBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byResourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.byResourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val byAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.byAccountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupJobsRequest
  ): zio.aws.backup.model.ListBackupJobsRequest.ReadOnly = new Wrapper(impl)
}
