package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBackupPlanFromJsonResponse(
    backupPlan: Optional[zio.aws.backup.model.BackupPlan] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse = {
    import GetBackupPlanFromJsonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse
      .builder()
      .optionallyWith(backupPlan.map(value => value.buildAwsValue()))(
        _.backupPlan
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly =
    zio.aws.backup.model.GetBackupPlanFromJsonResponse.wrap(buildAwsValue())
}
object GetBackupPlanFromJsonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupPlanFromJsonResponse =
      zio.aws.backup.model.GetBackupPlanFromJsonResponse(
        backupPlan.map(value => value.asEditable)
      )
    def backupPlan: Optional[zio.aws.backup.model.BackupPlan.ReadOnly]
    def getBackupPlan
        : ZIO[Any, AwsError, zio.aws.backup.model.BackupPlan.ReadOnly] =
      AwsError.unwrapOptionField("backupPlan", backupPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse
  ) extends zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly {
    override val backupPlan
        : Optional[zio.aws.backup.model.BackupPlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlan())
        .map(value => zio.aws.backup.model.BackupPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse
  ): zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly = new Wrapper(
    impl
  )
}
