package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateBackupSelectionResponse(
    selectionId: Optional[String] = Optional.Absent,
    backupPlanId: Optional[String] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse = {
    import CreateBackupSelectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse
      .builder()
      .optionallyWith(selectionId.map(value => value: java.lang.String))(
        _.selectionId
      )
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateBackupSelectionResponse.ReadOnly =
    zio.aws.backup.model.CreateBackupSelectionResponse.wrap(buildAwsValue())
}
object CreateBackupSelectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateBackupSelectionResponse =
      zio.aws.backup.model.CreateBackupSelectionResponse(
        selectionId.map(value => value),
        backupPlanId.map(value => value),
        creationDate.map(value => value)
      )
    def selectionId: Optional[String]
    def backupPlanId: Optional[String]
    def creationDate: Optional[Timestamp]
    def getSelectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionId", selectionId)
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse
  ) extends zio.aws.backup.model.CreateBackupSelectionResponse.ReadOnly {
    override val selectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionId())
      .map(value => value: String)
    override val backupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => value: String)
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse
  ): zio.aws.backup.model.CreateBackupSelectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
