package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportBackupPlanTemplateResponse(
    backupPlanTemplateJson: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse = {
    import ExportBackupPlanTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse
      .builder()
      .optionallyWith(
        backupPlanTemplateJson.map(value => value: java.lang.String)
      )(_.backupPlanTemplateJson)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly =
    zio.aws.backup.model.ExportBackupPlanTemplateResponse.wrap(buildAwsValue())
}
object ExportBackupPlanTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ExportBackupPlanTemplateResponse =
      zio.aws.backup.model.ExportBackupPlanTemplateResponse(
        backupPlanTemplateJson.map(value => value)
      )
    def backupPlanTemplateJson: Optional[String]
    def getBackupPlanTemplateJson: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("backupPlanTemplateJson", backupPlanTemplateJson)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse
  ) extends zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly {
    override val backupPlanTemplateJson: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanTemplateJson())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse
  ): zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
