package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReportPlanResponse(
    reportPlan: Optional[zio.aws.backup.model.ReportPlan] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse = {
    import DescribeReportPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse
      .builder()
      .optionallyWith(reportPlan.map(value => value.buildAwsValue()))(
        _.reportPlan
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly =
    zio.aws.backup.model.DescribeReportPlanResponse.wrap(buildAwsValue())
}
object DescribeReportPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeReportPlanResponse =
      zio.aws.backup.model
        .DescribeReportPlanResponse(reportPlan.map(value => value.asEditable))
    def reportPlan: Optional[zio.aws.backup.model.ReportPlan.ReadOnly]
    def getReportPlan
        : ZIO[Any, AwsError, zio.aws.backup.model.ReportPlan.ReadOnly] =
      AwsError.unwrapOptionField("reportPlan", reportPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse
  ) extends zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly {
    override val reportPlan
        : Optional[zio.aws.backup.model.ReportPlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportPlan())
        .map(value => zio.aws.backup.model.ReportPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse
  ): zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly = new Wrapper(
    impl
  )
}
