package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.FrameworkName
import scala.jdk.CollectionConverters._
final case class DescribeFrameworkRequest(frameworkName: FrameworkName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest = {
    import DescribeFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest
      .builder()
      .frameworkName(FrameworkName.unwrap(frameworkName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeFrameworkRequest.ReadOnly =
    zio.aws.backup.model.DescribeFrameworkRequest.wrap(buildAwsValue())
}
object DescribeFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeFrameworkRequest =
      zio.aws.backup.model.DescribeFrameworkRequest(frameworkName)
    def frameworkName: FrameworkName
    def getFrameworkName: ZIO[Any, Nothing, FrameworkName] =
      ZIO.succeed(frameworkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest
  ) extends zio.aws.backup.model.DescribeFrameworkRequest.ReadOnly {
    override val frameworkName: FrameworkName =
      zio.aws.backup.model.primitives.FrameworkName(impl.frameworkName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest
  ): zio.aws.backup.model.DescribeFrameworkRequest.ReadOnly = new Wrapper(impl)
}
