package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeleteBackupPlanResponse(
    backupPlanId: Optional[String] = Optional.Absent,
    backupPlanArn: Optional[ARN] = Optional.Absent,
    deletionDate: Optional[Timestamp] = Optional.Absent,
    versionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse = {
    import DeleteBackupPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
      .builder()
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        backupPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupPlanArn)
      .optionallyWith(
        deletionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly =
    zio.aws.backup.model.DeleteBackupPlanResponse.wrap(buildAwsValue())
}
object DeleteBackupPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DeleteBackupPlanResponse =
      zio.aws.backup.model.DeleteBackupPlanResponse(
        backupPlanId.map(value => value),
        backupPlanArn.map(value => value),
        deletionDate.map(value => value),
        versionId.map(value => value)
      )
    def backupPlanId: Optional[String]
    def backupPlanArn: Optional[ARN]
    def deletionDate: Optional[Timestamp]
    def versionId: Optional[String]
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getBackupPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupPlanArn", backupPlanArn)
    def getDeletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getVersionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
  ) extends zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly {
    override val backupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => value: String)
    override val backupPlanArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val deletionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val versionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse
  ): zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly = new Wrapper(impl)
}
