package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ReportPlanDescription, ReportPlanName}
import scala.jdk.CollectionConverters._
final case class UpdateReportPlanRequest(
    reportPlanName: ReportPlanName,
    reportPlanDescription: Option[ReportPlanDescription] = None,
    reportDeliveryChannel: Option[zio.aws.backup.model.ReportDeliveryChannel] =
      None,
    reportSetting: Option[zio.aws.backup.model.ReportSetting] = None,
    idempotencyToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest = {
    import UpdateReportPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest
      .builder()
      .reportPlanName(ReportPlanName.unwrap(reportPlanName): java.lang.String)
      .optionallyWith(
        reportPlanDescription.map(value =>
          ReportPlanDescription.unwrap(value): java.lang.String
        )
      )(_.reportPlanDescription)
      .optionallyWith(
        reportDeliveryChannel.map(value => value.buildAwsValue())
      )(_.reportDeliveryChannel)
      .optionallyWith(reportSetting.map(value => value.buildAwsValue()))(
        _.reportSetting
      )
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateReportPlanRequest.ReadOnly =
    zio.aws.backup.model.UpdateReportPlanRequest.wrap(buildAwsValue())
}
object UpdateReportPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateReportPlanRequest =
      zio.aws.backup.model.UpdateReportPlanRequest(
        reportPlanName,
        reportPlanDescription.map(value => value),
        reportDeliveryChannel.map(value => value.asEditable),
        reportSetting.map(value => value.asEditable),
        idempotencyToken.map(value => value)
      )
    def reportPlanName: ReportPlanName
    def reportPlanDescription: Option[ReportPlanDescription]
    def reportDeliveryChannel
        : Option[zio.aws.backup.model.ReportDeliveryChannel.ReadOnly]
    def reportSetting: Option[zio.aws.backup.model.ReportSetting.ReadOnly]
    def idempotencyToken: Option[String]
    def getReportPlanName: ZIO[Any, Nothing, ReportPlanName] =
      ZIO.succeed(reportPlanName)
    def getReportPlanDescription: ZIO[Any, AwsError, ReportPlanDescription] =
      AwsError.unwrapOptionField("reportPlanDescription", reportPlanDescription)
    def getReportDeliveryChannel: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.ReportDeliveryChannel.ReadOnly
    ] =
      AwsError.unwrapOptionField("reportDeliveryChannel", reportDeliveryChannel)
    def getReportSetting
        : ZIO[Any, AwsError, zio.aws.backup.model.ReportSetting.ReadOnly] =
      AwsError.unwrapOptionField("reportSetting", reportSetting)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest
  ) extends zio.aws.backup.model.UpdateReportPlanRequest.ReadOnly {
    override val reportPlanName: ReportPlanName =
      zio.aws.backup.model.primitives.ReportPlanName(impl.reportPlanName())
    override val reportPlanDescription: Option[ReportPlanDescription] = scala
      .Option(impl.reportPlanDescription())
      .map(value =>
        zio.aws.backup.model.primitives.ReportPlanDescription(value)
      )
    override val reportDeliveryChannel
        : Option[zio.aws.backup.model.ReportDeliveryChannel.ReadOnly] = scala
      .Option(impl.reportDeliveryChannel())
      .map(value => zio.aws.backup.model.ReportDeliveryChannel.wrap(value))
    override val reportSetting
        : Option[zio.aws.backup.model.ReportSetting.ReadOnly] = scala
      .Option(impl.reportSetting())
      .map(value => zio.aws.backup.model.ReportSetting.wrap(value))
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest
  ): zio.aws.backup.model.UpdateReportPlanRequest.ReadOnly = new Wrapper(impl)
}
