package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRestoreJobsResponse(
    restoreJobs: Option[Iterable[zio.aws.backup.model.RestoreJobsListMember]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse = {
    import ListRestoreJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
      .builder()
      .optionallyWith(
        restoreJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.restoreJobs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly =
    zio.aws.backup.model.ListRestoreJobsResponse.wrap(buildAwsValue())
}
object ListRestoreJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListRestoreJobsResponse =
      zio.aws.backup.model.ListRestoreJobsResponse(
        restoreJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def restoreJobs
        : Option[List[zio.aws.backup.model.RestoreJobsListMember.ReadOnly]]
    def nextToken: Option[String]
    def getRestoreJobs: ZIO[Any, AwsError, List[
      zio.aws.backup.model.RestoreJobsListMember.ReadOnly
    ]] = AwsError.unwrapOptionField("restoreJobs", restoreJobs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
  ) extends zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly {
    override val restoreJobs
        : Option[List[zio.aws.backup.model.RestoreJobsListMember.ReadOnly]] =
      scala
        .Option(impl.restoreJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.RestoreJobsListMember.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse
  ): zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly = new Wrapper(impl)
}
