package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ARN, IAMRoleArn, BackupSelectionName}
import scala.jdk.CollectionConverters._
final case class BackupSelection(
    selectionName: BackupSelectionName,
    iamRoleArn: IAMRoleArn,
    resources: Option[Iterable[ARN]] = None,
    listOfTags: Option[Iterable[zio.aws.backup.model.Condition]] = None,
    notResources: Option[Iterable[ARN]] = None,
    conditions: Option[zio.aws.backup.model.Conditions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupSelection = {
    import BackupSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupSelection
      .builder()
      .selectionName(
        BackupSelectionName.unwrap(selectionName): java.lang.String
      )
      .iamRoleArn(IAMRoleArn.unwrap(iamRoleArn): java.lang.String)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        listOfTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listOfTags)
      .optionallyWith(
        notResources.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notResources)
      .optionallyWith(conditions.map(value => value.buildAwsValue()))(
        _.conditions
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupSelection.ReadOnly =
    zio.aws.backup.model.BackupSelection.wrap(buildAwsValue())
}
object BackupSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.BackupSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupSelection =
      zio.aws.backup.model.BackupSelection(
        selectionName,
        iamRoleArn,
        resources.map(value => value),
        listOfTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notResources.map(value => value),
        conditions.map(value => value.asEditable)
      )
    def selectionName: BackupSelectionName
    def iamRoleArn: IAMRoleArn
    def resources: Option[List[ARN]]
    def listOfTags: Option[List[zio.aws.backup.model.Condition.ReadOnly]]
    def notResources: Option[List[ARN]]
    def conditions: Option[zio.aws.backup.model.Conditions.ReadOnly]
    def getSelectionName: ZIO[Any, Nothing, BackupSelectionName] =
      ZIO.succeed(selectionName)
    def getIamRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(iamRoleArn)
    def getResources: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("resources", resources)
    def getListOfTags
        : ZIO[Any, AwsError, List[zio.aws.backup.model.Condition.ReadOnly]] =
      AwsError.unwrapOptionField("listOfTags", listOfTags)
    def getNotResources: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("notResources", notResources)
    def getConditions
        : ZIO[Any, AwsError, zio.aws.backup.model.Conditions.ReadOnly] =
      AwsError.unwrapOptionField("conditions", conditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupSelection
  ) extends zio.aws.backup.model.BackupSelection.ReadOnly {
    override val selectionName: BackupSelectionName =
      zio.aws.backup.model.primitives.BackupSelectionName(impl.selectionName())
    override val iamRoleArn: IAMRoleArn =
      zio.aws.backup.model.primitives.IAMRoleArn(impl.iamRoleArn())
    override val resources: Option[List[ARN]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.primitives.ARN(item)
        }.toList
      )
    override val listOfTags
        : Option[List[zio.aws.backup.model.Condition.ReadOnly]] = scala
      .Option(impl.listOfTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.Condition.wrap(item)
        }.toList
      )
    override val notResources: Option[List[ARN]] = scala
      .Option(impl.notResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.primitives.ARN(item)
        }.toList
      )
    override val conditions: Option[zio.aws.backup.model.Conditions.ReadOnly] =
      scala
        .Option(impl.conditions())
        .map(value => zio.aws.backup.model.Conditions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupSelection
  ): zio.aws.backup.model.BackupSelection.ReadOnly = new Wrapper(impl)
}
